SET SQL_MODE = 'NO_AUTO_VALUE_ON_ZERO';
START TRANSACTION;
SET time_zone = '+00:00';

-- 
-- Estructura de tabla para la tabla `asociados`
-- 
CREATE TABLE `asociados` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(200) DEFAULT NULL,
  `CODIGO` varchar(30) DEFAULT NULL,
  `DATE` date DEFAULT NULL,
  `BARCODE` varchar(20) DEFAULT NULL,
  `STATUS` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `asociados`
-- 

INSERT INTO asociados VALUES
('1','Nombre de prueba Apellido','1008',NULL,NULL,'activo'),
('2',' ','',NULL,NULL,'activo'),
('3',' ','',NULL,NULL,'activo');

-- 
-- Estructura de tabla para la tabla `categorias`
-- 
CREATE TABLE `categorias` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `NOMBRE_CAT` varchar(20) NOT NULL,
  `CODIGO_CAT` varchar(10) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `categorias`
-- 

INSERT INTO categorias VALUES
('1','ALMUERZO','cat001'),
('2','REFACCIÓN','cat002');

-- 
-- Estructura de tabla para la tabla `credito_asociado`
-- 
CREATE TABLE `credito_asociado` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CODIGO_AS` varchar(20) NOT NULL,
  `CREDITO_AS` varchar(20) NOT NULL,
  `SOLVENT` tinyint(1) NOT NULL,
  `DATE_ING` date NOT NULL,
  `DATE_CANCE` date DEFAULT NULL,
  `TIPE` varchar(20) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `credito_asociado`
-- 

-- 
-- Estructura de tabla para la tabla `cuaderno_asociado`
-- 
CREATE TABLE `cuaderno_asociado` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CODIGO_AS` varchar(20) NOT NULL,
  `CREDITO_AS` varchar(20) NOT NULL,
  `SOLVENT` tinyint(1) NOT NULL,
  `DATE_ING` date NOT NULL,
  `DATE_CANCE` date DEFAULT NULL,
  `TIPE` varchar(20) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `cuaderno_asociado`
-- 

-- 
-- Estructura de tabla para la tabla `producto`
-- 
CREATE TABLE `producto` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `NOMBRE` varchar(20) NOT NULL,
  `TIPO` varchar(20) NOT NULL,
  `CAT_PROD` varchar(20) NOT NULL,
  `COD_TIPO` varchar(20) NOT NULL,
  `PRECIO_CREDITO` varchar(20) DEFAULT NULL,
  `PRECIO_CASH` varchar(20) DEFAULT NULL,
  `STATUS` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `producto`
-- 

INSERT INTO producto VALUES
('1','ALMUERZO_CONT','CONTADO','ALMUERZO','du001','3','13','1'),
('2','ALMUERZO_CREDIT','CREDITO','ALMUERZO','du002','16','0','1'),
('3','REFACCION_CREDIT','CREDITO','REFACCIÓN','du003',NULL,NULL,'1'),
('4','REFACCION_CONT','CONTADO','REFACCIÓN','du004',NULL,NULL,'0');

-- 
-- Estructura de tabla para la tabla `token`
-- 
CREATE TABLE `token` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TOKEN` varchar(60) NOT NULL,
  `DATE` date NOT NULL,
  `STATUS` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
-- 
-- Volcado de datos para la tabla `token`
-- 

INSERT INTO token VALUES
('1','asdf234sdg2asdghfsd2354','2023-05-31','1');

-- 
-- Estructura de tabla para la tabla `users`
-- 
CREATE TABLE `users` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(200) NOT NULL,
  `PASSWORD` varchar(100) NOT NULL,
  `ROLE` varchar(50) NOT NULL,
  `DATE` date NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `users`
-- 

INSERT INTO users VALUES
('1','admin','$2y$10$7.h44hqhh4JI4AFRJiFc.ea1k7hWeGzlVTffLG1mB5nFss90ruGiO','ADMIN','2023-05-31');

-- 
-- Estructura de tabla para la tabla `ventas`
-- 
CREATE TABLE `ventas` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CODIGO_AS` varchar(20) NOT NULL,
  `NOMBRE_AS` varchar(70) DEFAULT NULL,
  `COD_PROD_V` varchar(10) NOT NULL,
  `TIPO_PROD_V` varchar(20) NOT NULL,
  `NOMBRE_PROD_V` varchar(20) NOT NULL,
  `PAGO_CREDITO` varchar(10) DEFAULT NULL,
  `SUBS2` varchar(10) NOT NULL,
  `PAGO_CONT` varchar(10) DEFAULT NULL,
  `TOTAL` varchar(20) NOT NULL,
  `SOLVENT` varchar(5) DEFAULT NULL,
  `DATE_ING` date NOT NULL,
  `DATE_CANCE` date DEFAULT NULL,
  `HORA_INGRESO` time NOT NULL,
  `USUARIO_REG` varchar(50) NOT NULL,
  `STATUS` varchar(20) DEFAULT NULL,
  `USR_ANULADO` varchar(50) DEFAULT NULL,
  `DATE_ANULADO` date DEFAULT NULL,
  `HORA_ANUL` time DEFAULT NULL,
  `TOKENTEMPO` varchar(50) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
-- 
-- Volcado de datos para la tabla `ventas`
-- 

INSERT INTO ventas VALUES
('1','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','1','0','0','1','0','2023-06-01',NULL,'21:10:38','admin','',NULL,NULL,NULL,'202361211032'),
('2','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','20','0','0','20','0','2023-06-01',NULL,'23:05:19','admin','',NULL,NULL,NULL,'2023612357'),
('3','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','1','0','0','1','0','2023-06-02',NULL,'11:12:28','admin','',NULL,NULL,NULL,'202362111221'),
('4','1008','Nombre de prueba Apellido','du001','CONTADO','ALMUERZO_CONT','3','3','13','16','0','2023-06-02',NULL,'11:12:43','admin','',NULL,NULL,NULL,'202362111236'),
('5','1008','Nombre de prueba Apellido','du001','CONTADO','ALMUERZO_CONT','3','3','13','16','0','2023-06-02',NULL,'11:13:07','admin','',NULL,NULL,NULL,'20236211133'),
('6','1008','Nombre de prueba Apellido','du002','CREDITO','ALMUERZO_CREDIT','16','3','0','16','0','2023-06-02',NULL,'11:14:03','admin','',NULL,NULL,NULL,'20236211140'),
('7','1008','Nombre de prueba Apellido','du001','CONTADO','ALMUERZO_CONT','3','3','13','16','0','2023-06-02',NULL,'11:24:38','admin','',NULL,NULL,NULL,'202362112426'),
('8','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','12','0','0','12','0','2023-06-02',NULL,'11:25:36','admin','',NULL,NULL,NULL,'202362112426'),
('9','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','15','0','0','15','0','2023-06-02',NULL,'11:26:15','admin','',NULL,NULL,NULL,'202362112554'),
('10','1008','Nombre de prueba Apellido','du002','CREDITO','ALMUERZO_CREDIT','16','3','0','16','0','2023-06-02',NULL,'11:26:37','admin','',NULL,NULL,NULL,'202362112634'),
('11','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','1','0','0','1','0','2023-06-02',NULL,'11:40:07','admin','',NULL,NULL,NULL,'20236211401'),
('12','1008','Nombre de prueba Apellido','du003','CREDITO','REFACCION_CREDIT','1','0','0','1','0','2023-06-02',NULL,'20:13:03','admin','',NULL,NULL,NULL,'202362201259'),
('13','1008','Nombre de prueba Apellido','du002','CREDITO','ALMUERZO_CREDIT','16','3','0','16','0','2023-06-02',NULL,'20:13:11','admin','',NULL,NULL,NULL,'20236220139'),
('14','1008','Nombre de prueba Apellido','du002','CREDITO','ALMUERZO_CREDIT','16','3','0','16','0','2023-06-02',NULL,'20:18:36','admin','',NULL,NULL,NULL,'202362201833'),
('15','1008','Nombre de prueba Apellido','du002','CREDITO','ALMUERZO_CREDIT','16','3','0','16','0','2023-06-02',NULL,'20:19:28','admin','',NULL,NULL,NULL,'202362201924'),
('16','1008','Nombre de prueba Apellido','du001','CONTADO','ALMUERZO_CONT','3','3','13','16','0','2023-06-02',NULL,'20:19:57','admin','',NULL,NULL,NULL,'202362201953');

COMMIT;
