<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../session.php"; 
include 'conect.php';
date_default_timezone_set('America/Guatemala');

// Establecer conexión con la base de datos
$connection = new mysqli($hostname, $username, $pass, $database);

// Verificar si la conexión fue exitosa
if ($connection->connect_error) {
    die("Error de conexión: " . $connection->connect_error);
}

// Ruta y nombre de archivo para la copia de seguridad
$backupDir="../backup/";  // Cambia esto por la ruta donde deseas guardar la copia de seguridad
$dateCodeBackup = date("YmdHis");
$backupFile = $backupDir . $dateCodeBackup . "_Backup_du.sql";

echo $backupFile;

// Obtener el listado de tablas en la base de datos
$tables = array();
$result = $connection->query("SHOW TABLES");
while ($row = $result->fetch_row()) {
    $tables[] = $row[0];
}

// Abrir archivo de copia de seguridad
$file = fopen($backupFile, 'w');

if ($file) {
    // Recorrer las tablas y escribir el contenido en el archivo
    foreach ($tables as $table) {
        fwrite($file, "DROP TABLE IF EXISTS $table;\n");

        // Obtener la estructura de la tabla
        $resultStructure = $connection->query("SHOW CREATE TABLE $table");
        $rowStructure = $resultStructure->fetch_assoc();
        $createStatement = $rowStructure['Create Table'];

        // Agregar la declaración ENGINE=InnoDB
        $createStatement = str_replace("CREATE TABLE", "CREATE TABLE IF NOT EXISTS", $createStatement);
        $createStatement = str_replace("(\n", "(\nENGINE=InnoDB;\n", $createStatement);

        // Agregar la declaración ALTER TABLE ADD PRIMARY KEY
        $resultKeys = $connection->query("SHOW KEYS FROM $table WHERE Key_name = 'PRIMARY'");
        if ($resultKeys->num_rows > 0) {
            $rowKeys = $resultKeys->fetch_assoc();
            $createStatement = str_replace(");", ",\nADD PRIMARY KEY (`".$rowKeys['Column_name']."`)\n);", $createStatement);
        }

        fwrite($file, $createStatement . ";\n");

        // Obtener los datos de la tabla
        $resultData = $connection->query("SELECT * FROM $table");
        $numColumns = $resultData->field_count;

        while ($row = $resultData->fetch_row()) {
            $values = array();
            foreach ($row as $value) {
                if ($value === null) {
                    $values[] = 'NULL';
                } else {
                    $values[] = "'" . $connection->real_escape_string($value) . "'";
                }
            }
            fwrite($file, "INSERT INTO $table VALUES (".implode(",", $values).");\n");
        }

        fwrite($file, "\n");
    }

    fclose($file);
    echo "Copia de seguridad de la base de datos generada correctamente en: $backupFile";
} else {
    echo "Error al abrir el archivo de copia de seguridad.";
}

// Cerrar la conexión
$connection->close();
?>
