<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../session.php"; 
include 'conect.php';
date_default_timezone_set('America/Guatemala');

// Establecer conexión con la base de datos
$connection = new mysqli($hostname, $username, $pass, $database);

// Verificar si la conexión fue exitosa
if ($connection->connect_error) {
    die("Error de conexión: " . $connection->connect_error);
}

// Establecer el conjunto de caracteres UTF-8 para la conexión
$connection->set_charset("utf8");

// Ruta y nombre de archivo para la copia de seguridad
$backupDir="../backup/";  // Cambia esto por la ruta donde deseas guardar la copia de seguridad

if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true);  // Crea la carpeta con permisos 0755
}


$dateCodeBackup = date("ymdHis");
$backupFile = $backupDir . $dateCodeBackup . $database . ".sql";

// Abrir archivo de copia de seguridad
$file = fopen($backupFile, 'w');

if ($file) {
    // Agregar instrucciones SET sql_mode y START TRANSACTION
    $sqlModeStatement = "SET SQL_MODE = 'NO_AUTO_VALUE_ON_ZERO';";
    $startTransactionStatement = "START TRANSACTION;";
    $timezoneStatement = "SET time_zone = '+00:00';";

    // Escribir las instrucciones en el archivo de copia de seguridad
    fwrite($file, $sqlModeStatement . "\n");
    fwrite($file, $startTransactionStatement . "\n");
    fwrite($file, $timezoneStatement . "\n\n");

    // Obtener el listado de tablas en la base de datos
    $tables = array();
    $result = $connection->query("SHOW TABLES");
    while ($row = $result->fetch_row()) {
        $tables[] = $row[0];
    }

    // Recorrer las tablas y escribir el contenido en el archivo
    foreach ($tables as $table) {
        // Obtener la estructura de la tabla
        $resultStructure = $connection->query("SHOW CREATE TABLE $table");
        $rowStructure = $resultStructure->fetch_assoc();
        $createStatement = $rowStructure['Create Table'];

        // Agregar comentario con la estructura de la tabla
        $commentStatement = "-- \n-- Estructura de tabla para la tabla `$table`\n-- \n";
        fwrite($file, $commentStatement);
        fwrite($file, $createStatement . ";\n");

        // Obtener los datos de la tabla
        $resultData = $connection->query("SELECT * FROM $table");
        $numColumns = $resultData->field_count;

        // Agregar comentario con el volcado de datos
        $commentStatement2 = "-- \n-- Volcado de datos para la tabla `$table`\n-- \n";
        fwrite($file, $commentStatement2);

        // Obtener todas las filas en un solo conjunto de valores
        $values = array();
        while ($row = $resultData->fetch_row()) {
            $rowValues = array();
            foreach ($row as $value) {
                if ($value === null) {
                    $rowValues[] = 'NULL';
                } else {
                    $rowValues[] = "'" . $connection->real_escape_string(mb_convert_encoding($value, 'UTF-8')) . "'";
                }
            }
            $values[] = "(" . implode(",", $rowValues) . ")";
        }

        // Escribir el conjunto de valores en un solo INSERT INTO con saltos de línea
        if (!empty($values)) {
            $insertStatement = "INSERT INTO $table VALUES\n" . implode(",\n", $values) . ";";
            fwrite($file, "\n" . $insertStatement . "\n");
        }

        fwrite($file, "\n");
    }

    // Escribir sentencia COMMIT para finalizar la transacción
    fwrite($file, "COMMIT;\n");

    fclose($file);
    
    $status_database=1;
   

} else {
    $status_database=-1;
}

// Cerrar la conexión
$connection->close();



if($status_database==1){

     // Descargar el archivo de copia de seguridad
     header('Content-Type: application/octet-stream');
     header('Content-Disposition: attachment; filename="' . basename($backupFile) . '"');
     header('Content-Length: ' . filesize($backupFile));
     readfile($backupFile);
     exit();

}
else{
    echo $status_database;
}
?>
