<?php
session_start();

$server=$_SERVER["HTTP_HOST"]."/qa.du"; 
$home="http://".$server."/index.php";
$close="http://".$server."/includes/close.php";
$admin="http://".$server."/includes/admin.php";
$loginRed="http://".$server."/includes/session.php";

$session=isset($_SESSION['usuario']) ? $_SESSION['usuario'] : '';
$role=isset($_SESSION['role']) ? $_SESSION['role'] : '';


if ($_SESSION['usuario']==null || $_SESSION['usuario'] == "") {
    header("Location:".$loginRed);
  
    die();
  }

    
if ($_SESSION['role']=='GENERIC') {
    header("Location:".$loginRed);
  
    die();
  }

error_reporting(0);

require "../vendor/autoload.php";

# Nuestra base de datos
require "conect.php";

date_default_timezone_set('America/Guatemala');

$fechaInicio = $_POST['fechaInicio'];
$fechaFinal = $_POST['fechaFinal'];
$statusV = "activo";

$newDate1 = date("d/m/Y", strtotime($fechaInicio));
$newDate2 = date("d/m/Y", strtotime($fechaFinal));

$dateN = "Reporte_del_" . $newDate1 . "_al_" . $newDate2;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$documento = new Spreadsheet();
$documento
    ->getProperties()
    ->setCreator("Du")
    ->setLastModifiedBy('BaulPHP')
    ->setTitle('Archivo generado desde MySQL')
    ->setDescription('Reporte de Ventas');

$hojaDeVentas = $documento->getActiveSheet();
$hojaDeVentas->setTitle("Ventas");

# Encabezado de los productos
$encabezado = ["RECIBO", "CodigoAsociado", "NombreAsociado", "Producto", "Subsidio", "Crédito", "Contado", "PrecioTotal", "Tipo", "FechaDeCompra"];
# El último argumento es por defecto A1
$hojaDeVentas->fromArray($encabezado, null, 'A1');

$consulta = mysqli_query($con, "SELECT * FROM ventas WHERE DATE_ING BETWEEN '$fechaInicio' AND '$fechaFinal' AND STATUS='$statusV'");
$conteo = mysqli_num_rows($consulta);

if ($conteo > 0) {
    $totalCredito = 0;
    $totalContado = 0;
    $totalTotal = 0;
    $totalSub = 0;

    $numeroDeFila = 2;

    while ($row3 = mysqli_fetch_array($consulta)) {
        $transID = $row3['ID'];
        $codigoCliente = $row3['CODIGO_AS'];
        $nombreCliente = $row3['NOMBRE_AS'];
        $productos = $row3['NOMBRE_PROD_V'];
        $credito1 = $row3['PAGO_CREDITO'];
        $subs = $row3['SUBS2'];
        $credito = $credito1 - $subs;
        $contado = $row3['PAGO_CONT'];
        $total = $row3['TOTAL'];
        $tipo = $row3['TIPO_PROD_V'];
        $fecha = $row3['DATE_ING'];

        $newDate = date("d-m-Y", strtotime($fecha));

        # Escribir registros en el documento
        $hojaDeVentas->setCellValueByColumnAndRow(1, $numeroDeFila, $transID);
        $hojaDeVentas->setCellValueByColumnAndRow(2, $numeroDeFila, $codigoCliente);
        $hojaDeVentas->setCellValueByColumnAndRow(3, $numeroDeFila, $nombreCliente);
        $hojaDeVentas->setCellValueByColumnAndRow(4, $numeroDeFila, $productos);
        $hojaDeVentas->setCellValueByColumnAndRow(5, $numeroDeFila, $subs);
        $hojaDeVentas->setCellValueByColumnAndRow(6, $numeroDeFila, $credito);
        $hojaDeVentas->setCellValueByColumnAndRow(7, $numeroDeFila, $contado);
        $hojaDeVentas->setCellValueByColumnAndRow(8, $numeroDeFila, $total);
        $hojaDeVentas->setCellValueByColumnAndRow(9, $numeroDeFila, $tipo);
        $hojaDeVentas->setCellValueByColumnAndRow(10, $numeroDeFila, $newDate);
        $numeroDeFila++;

        $totalCredito = $totalCredito + $credito;
        $totalContado = $totalContado + $contado;
        $totalSub = $totalSub + $subs;
        $totalTotal = $totalTotal + $total;
    }

    $hojaDeVentas->setCellValueByColumnAndRow(5, $numeroDeFila, $totalSub);
    $hojaDeVentas->setCellValueByColumnAndRow(6, $numeroDeFila, $totalCredito);
    $hojaDeVentas->setCellValueByColumnAndRow(7, $numeroDeFila, $totalContado);
    $hojaDeVentas->setCellValueByColumnAndRow(8, $numeroDeFila, $totalTotal);
	$rowTotal=$numeroDeFila+1;

	$rangoTotal='E' . $rowTotal . ':F'.$rowTotal;
	$hojaDeVentas->mergeCells($rangoTotal);
	$hojaDeVentas->setCellValue('E' . $rowTotal, $totalSub+$totalCredito);

    // Obtener el formato contable
$formatoContable = 'Q #,##0.00_-';

// Establecer formato contable para los campos de crédito, contado y precio total
for ($row = 2; $row <= $numeroDeFila; $row++) {
    $hojaDeVentas->getStyle('E' . $row)->getNumberFormat()->setFormatCode($formatoContable);
    $hojaDeVentas->getStyle('F' . $row)->getNumberFormat()->setFormatCode($formatoContable);
    $hojaDeVentas->getStyle('G' . $row)->getNumberFormat()->setFormatCode($formatoContable);
    $hojaDeVentas->getStyle('H' . $row)->getNumberFormat()->setFormatCode($formatoContable);

	$hojaDeVentas->getStyle('E' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_JUSTIFY);
	$hojaDeVentas->getStyle('F' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_JUSTIFY);
	$hojaDeVentas->getStyle('G' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_JUSTIFY);
    $hojaDeVentas->getStyle('H' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_JUSTIFY);

}

// Establecer negrita y color de fondo para la última fila de las columnas E y F
$ultimaFila = $numeroDeFila;
$hojaDeVentas->getStyle('E' . $ultimaFila)->getFont()->setBold(true)->getColor()->setARGB('005100');
$hojaDeVentas->getStyle('E' . $ultimaFila)->getFont()->setSize(14);
$hojaDeVentas->getStyle('F' . $ultimaFila)->getFont()->setBold(true)->getColor()->setARGB('FF4E00');
$hojaDeVentas->getStyle('F' . $ultimaFila)->getFont()->setSize(14);
$hojaDeVentas->getStyle('G' . $ultimaFila)->getFont()->setBold(true);
$hojaDeVentas->getStyle('G' . $ultimaFila)->getFont()->setSize(14);
$hojaDeVentas->getStyle('H' . $ultimaFila)->getFont()->setBold(true);
$hojaDeVentas->getStyle('H' . $ultimaFila)->getFont()->setSize(14);

$hojaDeVentas->getStyle('A1:J1')->getFont()->setBold(true);
$hojaDeVentas->getStyle('A1:J1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);



// Obtener el número de columnas en la hoja de cálculo
$numeroColumnas = $hojaDeVentas->getHighestColumn();

// Ajustar el ancho de cada columna al contenido de texto
for ($col = 'A'; $col <= $numeroColumnas; $col++) {
    $hojaDeVentas->getColumnDimension($col)->setAutoSize(true);
}

// Calcular el rango de celdas utilizado en la hoja
$ultimaColumna = $hojaDeVentas->getHighestColumn();
$ultimaFilaG = $hojaDeVentas->getHighestRow();
$rangoCeldas = 'A1:' . $ultimaColumna . $ultimaFilaG-1;

// Aplicar bordes a todas las celdas en el rango
$hojaDeVentas->getStyle($rangoCeldas)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);


// Agregar relleno a las celdas en el rango
$hojaDeVentas->getStyle($rangoCeldas)->getAlignment()->setWrapText(true);
$hojaDeVentas->getStyle($rangoCeldas)->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
$hojaDeVentas->getStyle($rangoCeldas)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
$hojaDeVentas->getStyle($rangoCeldas)->getAlignment()->setIndent(1);

//Estilo total

$hojaDeVentas->getStyle($rangoTotal)->getFont()->setSize(16);
$hojaDeVentas->getStyle($rangoTotal)->getFont()->setBold(true);
$hojaDeVentas->getStyle($rangoTotal)->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
$hojaDeVentas->getStyle($rangoTotal)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
$hojaDeVentas->getStyle($rangoTotal)->getNumberFormat()->setFormatCode($formatoContable);
$hojaDeVentas->getStyle($rangoTotal)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);




    $fileName = "Ventas_" . $dateN . ".xlsx";

    // Crear un "escritor"
    $writer = new Xlsx($documento);
	error_log('El archivo XLSX se generó correctamente.'); // Puedes personalizar el mensaje de error



    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
    $writer->save('php://output');
} else {
    echo 1;
  
}


?>
