<?php
session_start(); // Asegurarse de iniciar la sesión antes de acceder a $_SESSION

$printers = [];

if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
    $output = shell_exec('wmic printer get Name');
    $lines = explode("\n", trim($output));
    foreach ($lines as $line) {
        if (!empty($line) && $line !== 'Name') {
            $printer = trim($line);
            $printers[] = $printer;
        }
    }
}elseif (strtoupper(PHP_OS) === 'LINUX') {
    // En caso de que sea Linux
    $output = shell_exec('lpstat -a');
    $lines = explode("\n", trim($output));
    foreach ($lines as $line) {
        $printer = explode(" ", $line)[0];
        $printers[] = $printer;
    }

} elseif (strtoupper(PHP_OS) === 'DARWIN') {
    // En caso de que sea macOS
    exec('lpstat -p', $output);
    // Analizar la salida del comando para obtener los nombres de las impresoras
    foreach ($output as $line) {
        if (strpos($line, 'printer ') !== false) {
            $printer = trim(substr($line, strpos($line, 'printer ') + 8));
            $printers[] = $printer;
        }
    }

} else {
    // En caso de que el sistema operativo no sea compatible
    echo 'Sistema operativo no compatible';
    exit;
}

// Obtener el valor seleccionado previamente, si existe
$selectedPrinter = isset($_SESSION['selectedPrinter']) ? $_SESSION['selectedPrinter'] : '';

// Asignar la primera impresora de la lista si no hay una seleccionada previamente
if (empty($selectedPrinter) && !empty($printers)) {
    $selectedPrinter = explode(" ", $printers[0])[0]; // Extraer solo el nombre de la impresora
    $_SESSION['selectedPrinter'] = $selectedPrinter;
}

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener la impresora seleccionada del formulario
    $selectedPrinter = isset($_POST['printer']) ? $_POST['printer'] : '';

    // Almacenar la impresora seleccionada en la sesión
    $_SESSION['selectedPrinter'] = $selectedPrinter;
}
echo $selectedPrinter;
?>

<form method="post" class="selectPrint">
    <label for="printer">Impresora</label>
    <select name="printer" id="printer">
        <?php foreach ($printers as $printer): ?>
            <?php
            // Obtener solo el nombre de la impresora
            $printerName = explode(" ", $printer)[0];
            ?>
            <option value="<?php echo $printerName; ?>" <?php if ($selectedPrinter === $printerName) echo 'selected'; ?>><?php echo $printerName; ?></option>
        <?php endforeach; ?>
    </select>
</form>

<script>
    // Obtener el elemento select
    var printerSelect = document.getElementById('printer');

    // Capturar el evento de cambio
    printerSelect.addEventListener('change', function() {
        // Enviar el formulario automáticamente
        this.form.submit();
    });
</script>
